library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;

entity scanning_tb is

end scanning_tb;

architecture arch of scanning_tb is
    component scanning is
    Port ( clk : in STD_LOGIC;
           start : in STD_LOGIC;
           t_last : in STD_LOGIC;
           adder_enable : out STD_LOGIC;
           fifo_wr_en : out STD_LOGIC;
           scan_finish : out STD_LOGIC;
           address_0 : out STD_LOGIC_VECTOR (4 downto 0);
           address_1 : out STD_LOGIC_VECTOR (4 downto 0);
           address_2 : out STD_LOGIC_VECTOR (4 downto 0);
           address_3 : out STD_LOGIC_VECTOR (4 downto 0));
end component scanning;

signal address_0_tb : STD_LOGIC_VECTOR (4 downto 0);
signal address_1_tb : STD_LOGIC_VECTOR (4 downto 0);
signal address_2_tb : STD_LOGIC_VECTOR (4 downto 0);
signal address_3_tb : STD_LOGIC_VECTOR (4 downto 0);

signal scan_finish_tb : STD_LOGIC;
signal adder_enable_tb : STD_LOGIC;
signal fifo_wr_en_tb : STD_LOGIC;
signal start_tb : STD_LOGIC;
signal t_last_tb : STD_LOGIC;

signal clk_tb : std_logic:='0';


begin

instance1: component scanning
     port map(        clk => clk_tb,
           start => start_tb,
           t_last => t_last_tb,
           adder_enable => adder_enable_tb,
           fifo_wr_en => fifo_wr_en_tb,
           scan_finish => scan_finish_tb,
           address_0 => address_0_tb,
           address_1 => address_1_tb,
           address_2 => address_2_tb,
           address_3 => address_3_tb);

clk_process: process
begin 
                wait for 50 ns;
             clk_tb <= not(clk_tb);
end process;


t_last_tb <= '0',
             '1' after 50 ns,
             '0' after 100 ns,
             '1' after 500 ns,
             '0' after 550 ns,
             '1' after 950 ns,
             '0' after 1000 ns,
             '1' after 1400 ns,
             '0' after 1450 ns,
             '1' after 1850 ns,
             '0' after 1900 ns,
             '1' after 2300 ns,
             '0' after 2350 ns,
             '1' after 2750 ns,
             '0' after 2800 ns,
             '1' after 3200 ns,
             '0' after 3250 ns,
             '1' after 3650 ns,
             '0' after 3700 ns,
             '1' after 4100 ns,
             '0' after 4150 ns,
             '1' after 4550 ns,
             '0' after 4600 ns,
             '1' after 5000 ns,
             '0' after 5050 ns,
             '1' after 5450 ns,
             '0' after 5500 ns,
             '1' after 5900 ns,
             '0' after 5950 ns,
             '1' after 6350 ns,
             '0' after 6400 ns,
             '1' after 6800 ns,
             '0' after 6850 ns,
             '1' after 7250 ns,
             '0' after 7300 ns,
             '1' after 7700 ns,
             '0' after 7750 ns,
             '1' after 8150 ns,
             '0' after 8200 ns,
             '1' after 8600 ns,
             '0' after 8650 ns,
             '1' after 9050 ns,
             '0' after 9100 ns,
             '1' after 9500 ns,
             '0' after 9550 ns,
             '1' after 9950 ns,
             '0' after 10000 ns,
             '1' after 10400 ns,
             '0' after 10450 ns,
             '1' after 10850 ns,
             '0' after 10900 ns,
             '1' after 11300 ns,
             '0' after 11350 ns,
             '1' after 11750 ns,
             '0' after 11800 ns,
             '1' after 12200 ns,
             '0' after 12250 ns,
             '1' after 12650 ns,
             '0' after 12700 ns,
             '1' after 13100 ns,
             '0' after 13150 ns,
             '1' after 13550 ns,
             '0' after 13600 ns,
             '1' after 14000 ns,
             '0' after 14050 ns,
             '1' after 14450 ns,
             '0' after 14500 ns,
             '1' after 14900 ns,
             '0' after 14950 ns,
             '1' after 15350 ns,
             '0' after 15400 ns,
             '1' after 15800 ns,
             '0' after 15850 ns,
             '1' after 16250 ns,
             '0' after 16300 ns,
             '1' after 16700 ns,
             '0' after 16750 ns,
             '1' after 17150 ns,
             '0' after 17200 ns,
             '1' after 17600 ns,
             '0' after 17650 ns;

start_tb <= '1';

end architecture arch;


